﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

//GarageController is responsible for controlling interaction with the garage
public class GarageController : MonoBehaviour
{
    public Constants.CarType Type;

    private void OnTriggerStay2D(Collider2D collision)
    {
        if (Input.GetKeyDown(Constants.InteractKeyCode))
        {
            if (!MissionsManager.Instance.IsOnMission)  //We can only buy cars when not on a mission
            {
                if (collision.name == Constants.PlayerCarObjectName)
                {
                    //The player wants to open the garage, so let's do it
                    GameManager.Instance.CarSelector.Show(Type);
                }
            }
        }
    }
}
